clear all;
close all;
clc;

%Caricamento delle matrici O/D e della mappatura
load 'IMQ2013_zonecampionarie';
fprintf('File MAT di riferimento:  IMQ2013_zonecampionarie.mat\n\n');

%Creazione del nuvo file con le nuove matrici
SPUB_ResPIEx100mPuIGt = ResPIEmPuIGt./(ResPIEmPuIGt+ResPIEmPrIGt)*100;
SPUB_ResPIEx100mPuIGsr = ResPIEmPuIGsr./(ResPIEmPuIGsr+ResPIEmPrIGsr)*100;
SPUB_ResTOx100mPuIGt = ResTOmPuIGt./(ResTOmPuIGt+ResTOmPrIGt)*100;
SPUB_ResTOx100mPuIGsr = ResTOmPuIGsr./(ResTOmPuIGsr+ResTOmPrIGsr)*100; 
SPUB_ResPIEx100mPuOPt = ResPIEmPuOPt./(ResPIEmPuOPt+ResPIEmPrOPt)*100;
SPUB_ResTOx100mPuOPt = ResTOmPuOPt./(ResTOmPuOPt+ResTOmPrOPt)*100;
save IMQ2013_sceltamezzopubblico zoneA coordX coordY SPUB_ResPIEx100mPuIGt SPUB_ResPIEx100mPuIGsr SPUB_ResTOx100mPuIGt SPUB_ResTOx100mPuIGsr SPUB_ResPIEx100mPuOPt SPUB_ResTOx100mPuOPt;
fprintf('FILE MAT CREATO:  IMQ2013_sceltamezzopubblico.mat\n');

%Scrittura dati sul file di testo 
for i=1:208;
    SPRODpubb(i) = sum(ResPIEmPuOPt(i,:));
    SPRODpriv(i) = sum(ResPIEmPrOPt(i,:));
end
PERC = SPRODpubb./(SPRODpubb+SPRODpriv)*100;
file = fopen('SceltaMezzoPubblico.txt','w');
zoneA(209)=[]; 
stampa = [zoneA PERC' coordX coordY]; stampa=stampa';
fprintf(file,'%s %f %f %f\r\n',stampa);
fclose('all');
fprintf('FILE TXT CREATO:  SceltaMezzoPubblico.txt\n');
